/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.api.common.data.ITraderStandings;
import dev.toma.gunsrpg.api.common.data.ITraderStatus;
import dev.toma.gunsrpg.common.quests.mayor.TraderStatus;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.util.helper.ReputationHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerTraderStandings
implements ITraderStandings,
INBTSerializable<ListNBT> {
    private final Map<UUID, TraderStatus> statusMap = new HashMap<UUID, TraderStatus>();
    private final IRequestFactoryProvider requestProvider;
    private final PlayerEntity player;

    public PlayerTraderStandings(IRequestFactoryProvider requestProvider, PlayerEntity player) {
        this.requestProvider = requestProvider;
        this.player = player;
    }

    @Override
    public ITraderStatus getStatusWithTrader(UUID traderId) {
        return this.statusMap.computeIfAbsent(traderId, id -> new TraderStatus(this.requestProvider, this.player));
    }

    @Override
    public void questFinished(UUID traderId, Quest<?> quest) {
        ITraderStatus status = this.getStatusWithTrader(traderId);
        ReputationHelper.awardReputationForCompletedQuest(status, quest);
        this.requestProvider.getRequestFactory().makeSyncRequest();
    }

    @Override
    public void questFailed(UUID traderId, Quest<?> quest) {
        ITraderStatus status = this.getStatusWithTrader(traderId);
        ReputationHelper.takeReputationForFailedQuest(status, quest);
        this.requestProvider.getRequestFactory().makeSyncRequest();
    }

    public ListNBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, TraderStatus> entry : this.statusMap.entrySet()) {
            UUID uuid = entry.getKey();
            TraderStatus status = entry.getValue();
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74772_a("uuidMost", uuid.getMostSignificantBits());
            nbt.func_74772_a("uuidLeast", uuid.getLeastSignificantBits());
            nbt.func_218657_a("status", (INBT)status.serializeNBT());
            list.add((Object)nbt);
        }
        return list;
    }

    public void deserializeNBT(ListNBT list) {
        this.statusMap.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT nbt = list.func_150305_b(i);
            long most = nbt.func_74763_f("uuidMost");
            long least = nbt.func_74763_f("uuidLeast");
            UUID uuid = new UUID(most, least);
            TraderStatus status = new TraderStatus(this.requestProvider, this.player);
            status.deserializeNBT(nbt.func_74775_l("status"));
            this.statusMap.put(uuid, status);
        }
    }

    @FunctionalInterface
    public static interface IRequestFactoryProvider {
        public IPlayerCapEntry.IClientSynchReq getRequestFactory();
    }
}

